//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.1 Page 363 
//Title: Laminar Draining from a Pool

model Ex8_1
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water";
parameter Real mu_w(unit = "kg/ m.s") = 0.001002 "Viscosity of water";
parameter Real D(unit = "cm") = 6 "Inner diameter of hose";
parameter Real L(unit = "m") = 65 "Length of hose";
parameter Real H(unit = "m") = 2.2 "Initial height difference from the pool surface to the outlet of the hose";
parameter Real alpha_1(unit = "-") = 2 "kinetic energy correction factor"; 
               //For fully developed laminar flow - Assumption
parameter Real alpha_2(unit = "-") = 1.05 "kinetic energy correction factor"; //For turbulent
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real ep(unit = "-") = 0 "Roughness";

//=================
//Variable Section 
Real V(unit = "m/s") "Speed of water"; //Solution from quadractic equation
Real v(unit = "Lpm") "Volumeteric flow rate of water at the start of draining";
String Flow;
Real Re(unit = "-") "Reynolds number";

//Variables for turbulent flow
Real V_t(unit = "m/s") "Velocity of water";
Real v_t(unit = "LPM") "Volume flow rate"; 
Real h_Lt(unit = "m") "Head loss";
Real Re_t(unit = "-",start=100) "Reynolds number";
Real f_t(unit = "-",start=0.1) "Friction factor";

//=================
//Equation Section
equation 

V^2 + (64*mu_w*L)/(Rho_w*((D*0.01)^2)*alpha_1)*V-(2*g*H/alpha_1)=0; //Quadratic equation
v = V*((pi/4)*(D*0.01)^2)*1000*60;  

/*Multiplying D by 0.01 to convert cm to m
Multiplying v by 1000 to convert m^3 to L
Multiplying v by 60 to convert s to min */

Re = (Rho_w*V*D*0.01)/(mu_w);

/*Book steps is wrong - Unit conversion of D is wrong 
Answer provided in the book is wrong
Book answer, v= 0.627 Lpm
Obtained answer, v = 740.4 Lpm*/

//Checking flow
if Re<2300 
then
Flow = "Laminar";
else 
Flow = "Turbulent";
end if;

Modelica.Utilities.Streams.print(Flow); 

/*Hence, the assumption of laminar is wrong, 
recalculation must be done with turbulent*/  

Re_t = (Rho_w*V_t*D*0.01)/(mu_w);
(alpha_2*((V_t^2)/(2*g))) = H-h_Lt;
h_Lt = f_t*(L/(D*0.01))*((V_t^2)/(2*g));

//Colbroke Equation
1 / sqrt(f_t) = (-2) * log10(ep / D * 0.01 / 3.7 + 2.51 / (Re_t * sqrt(f_t)));
v_t = V_t*((pi/4)*(D*0.01)^2)*1000*60;


end Ex8_1;
//=================
