//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.11 Page 400
//Title: Measuring Flow Rate with an Orifice Meter

model Ex8_11
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real d(unit = "cm") = 3 "Diameter of orifice meter";
parameter Real D(unit = "cm") = 4 "Diameter of pipe";
parameter Real Cd_g(unit = "-") = 0.61 "Discharge coefficient of the orifice meter - First Guess";
parameter Real Rho_m(unit = "kg/m3") = 788.4 "Density of methanol";
parameter Real mu(unit = "kg/m.s") = 5.857*0.0001 "Dynamic viscosity of methanol";
parameter Real h(unit = "cm") = 11 "Differential height of the manometer";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real Rho_Hg(unit = "kg/m3") = 13600 "Density of mercury";

//=================
//Variable Section 
Real beta(unit = "-") "Diameter ratio";
Real A0(unit = "m2") "Throat area of the orifice";
Real Ac(unit = "m2") "Area of the pipe";
Real v(unit = "m3/s") "Volume flow rate";
Real V(unit = "m/s") "Average flow velocity in the pipe";
Real Re(unit = "-") "Reynolds number";
Real Cd(unit = "-") "Discharge coefficient";
Real v_actual(unit = "L/s") "Actual Volume flow rate";
Real V_actual(unit = "m/s") "Actual Average flow velocity in the pipe";
Real Re_actual(unit = "-") "Actual Reynolds number";

//=================
//Equation Section
equation 
beta = d/D;
A0 = (pi/4)*((d*0.01)^2); 
//Multiplying d by 0.01 to convert cm to m

Ac = (pi/4)*((D*0.01)^2); 
//Multiplying D by 0.01 to convert cm to m

v = (A0*Cd_g)*sqrt((2*((Rho_Hg/Rho_m)-1)*g*h*0.01)/(1-(beta^4))); 
//Multiplying h by 0.01 to convert cm to m

V = v/Ac;
Re = (Rho_m*V*D*0.01)/(mu);

//Orifice discharge coefficient relation
Cd = 0.5959+(0.0312*(beta^2.1))-(0.184*(beta^8))+((91.71*(beta^2.5))/(Re^0.75));

//Checking if the Cd guess and Cd actual differing 
if Cd==Cd_g
then v_actual = v;
else v_actual = ((A0*Cd)*sqrt((2*((Rho_Hg/Rho_m)-1)*g*h*0.01)/(1-(beta^4))))*1000; 
//Multiplying v_actual by 1000 to convert m3/s to L/s
end if;

//Recalculating with actual Cd value

V_actual = v_actual/(Ac*1000);
//Dividing v_actual by 1000 to convert L/s to m3/s

Re_actual = (Rho_m*V_actual*D*0.01)/(mu);
//Multiplying D by 0.01 to convert cm to m

end Ex8_11;
//=================
