//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.4 Page 375
//Title: Determining the Pressure Drop in a Water Pipe

model Ex8_4
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real v(unit = "ft3/s") = 0.2 "Volumeteric flow rate of water";
parameter Real D(unit = "in") = 2 "Diameter of horizontal pipe";
parameter Real Rho_w(unit = "lbm/ft3") = 62.36 "Density of water";
parameter Real mu_w(unit = "lbm/ft.s") = 7.536*0.0001 "Viscosity of water";
parameter Real L(unit = "ft") = 200 "Length of pipe";
parameter Real g(unit = "ft/s2") = 32.2 "Gravitational constant";

//From Table 8–2, Page No.371
parameter Real e(unit = "ft") = 0.000007 "Roughness for Stainless steel"; 

//=================
//Variable Section 
Real A(unit = "ft") "Area of the pipe";
Real V(unit = "ft/s") "Average velocity"; 
Real Re(unit = "-") "Reynolds number";
Real RR(unit = "-") "Relative roughness of the pipe"; //RR = ephisilon/D
Real f(unit = "-") "Friction factor";
Real Del_P(unit = "psi") "Pressure drop";
Real W_pump(unit = "W") "Required power input";
Real h_L(unit = "ft") "Head loss";
String Flow;


//=================
//Equation Section
equation 
//Condition checking for laminar 
A = ((pi/4)*(D/12)^2);
V = v/A;
Re = Rho_w*V*(D/12)/mu_w;

if Re<2300
then 
Flow = "Laminar";
else 
Flow = "Turbulent";
end if;

Modelica.Utilities.Streams.print(Flow); 

RR = e/(D/12); 
//Dividing D by 12 to convert inch to ft

//Colebrook equation 
1/sqrt(f)=-2*log10((RR/3.7)+(2.51/(Re*sqrt(f))));

Del_P = (f*(L/(D/12))*((Rho_w*(V^2))/2)*(1/32.2))/144; 
//Dividing Del_P by 144 to convert lbf/ft2 to psi

h_L = f*(L/(D/12))*(V^2/(2*g));
//Dividing D by 12 to convert inch to ft
 
W_pump = v*Del_P*144/0.737; 
//Multiplying Del_P by 144 to convert psi to lbf/ft2 

end Ex8_4;
//=================

