//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.5 Page 377
//Title: Determining the Flow Rate of Air in a Duct

model Ex8_5
extends Modelica.Constants;

//=================
//Parameter Section
//From Problem Ex8_3
parameter Real L(unit = "m") = 300 "Length of circular duct"; //Duct length is doubled
parameter Real D(unit = "m") = 0.267 "Diameter of the duct"; //Diameter remains constant

//Properties of air determined at 1 atm and 35 C
parameter Real kv(unit = "m2/s") = 1.655*0.00001 "Kinematic viscosity of air";
parameter Real h_L(unit = "m") = 20 "Maximum head loss";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//From Problem Ex8_3
parameter Real v_old(unit = "m3/s") = 0.35 "Old volume flow rate";
parameter Real RR(unit = "-") = 0 "Relative roughness";


//=================
//Variable Section 

Real V(unit = "m/s") "Average velocity"; 
Real v_m1(unit = "m3/s") "Volume flow rate by Method-1";
Real v_m2(unit = "m3/s") "Volume flow rate by Method-2";
Real Re(unit = "-",start=100) "Reynolds number";
Real f(unit = "-",start=0.1) "Friction factor";

//Real v_m2(unit = "m3/s") "Volume flow rate by Method-2";
Real v_new(unit = "m3/s") "New Volume flow rate";
Real v_drop(unit = "m3/s") "Drop in flow rate";
Real Percentage_change(unit = "%") "Percentage change in volume flow rate";


//=================
//Equation Section
equation 


//Method-1 : Iterative approach: Using Equation Solver

V = v_m1/((pi/4)*(D^2));
Re = (V*D)/kv;

//Colebrook equation
(1/sqrt(f))=-2*log10((2.51/(Re*sqrt(f))));
h_L = f*(L/D)*((V^2)/(2*g));


//Method-2 : Swamee–Jain relation
v_m2 = -0.965*(((g*D^5*h_L)/L)^0.5)*log((RR)+((3.17*kv^2*L)/(g*D^3*h_L))^0.5);
v_new = v_m2;

//Percentage change in volume flow rate
v_drop = v_old-v_new;
Percentage_change = ((v_old-v_new)/v_old)*100;


end Ex8_5;
//=================

