//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.6 Page 378
//Title: Turbulent Draining from a Pool

model Ex8_6
extends Modelica.Constants;

//=================
//Parameter Section
//From Example 8_1
parameter Real D(unit = "cm") = 2 "Inner diameter of the hose"; 
parameter Real ep(unit = "cm") = 0.002 "Average roughness height";
parameter Real mu_w(unit = "kg/m.s") = 0.001002 "Dynamic viscosity of water";
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real L(unit = "m") = 65 "Length of the hose";
parameter Real H(unit = "m") = 2.2 "Initial height difference from the pool surface to the outlet of the hose";
parameter Real alpha_2(unit = "-") = 1.05 "Kinetic energy correction factor";
               //Fully developed turbulent pipe flow at the outlet
                 
                         
//=================
//Variable Section 
Real V(unit = "m/s") "Average velocity before iteration";
Real v(unit = "LPM") "Volume flow rate at the start of draining"; 
Real h_L(unit = "m") "Head loss";
Real Re(unit = "-",start=100) "Reynolds number";
Real f(unit = "-",start=0.1) "Friction factor";
String Flow;

//=================
//Equation Section
equation 

//Solving simultaneous equation to get V

Re = (Rho_w*V*D*0.01)/(mu_w);
(alpha_2*((V^2)/(2*g))) = H-h_L;
h_L = f*(L/(D*0.01))*((V^2)/(2*g));

//Colbroke Equation
1 / sqrt(f) = (-2) * log10(ep / D * 0.01 / 3.7 + 2.51 / (Re * sqrt(f)));
v = V*((pi/4)*(D*0.01)^2)*1000*60;


//Checking for Flow condition
if Re>4000 
then Flow = "Turbulent";
else Flow = "Laminar";
end if;


Modelica.Utilities.Streams.print(Flow); 

//The answer may slightly vary due to rounding off values

end Ex8_6;
//=================

