//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.8 Page 389
//Title: Pumping Water through Two Parallel Pipes

model Ex8_8
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real z_A(unit = "m") = 5 "Elevation of one reservoir"; 
parameter Real z_B(unit = "m") = 13 "Elevation of another reservoir"; 
parameter Real D1(unit = "cm") = 4 "Diameter of pipe-1";
parameter Real D2(unit = "cm") = 8 "Diameter of pipe-2";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real eff(unit = "%") = 70 "Efficiency of motor–pump";
parameter Real W(unit = "kW") = 8 "Power of pump";
parameter Real L(unit = "m") = 36 "Length of pipe";

//From Table 8–2, Page No.371
parameter Real e(unit = "mm") = 0.045 "Roughness of commercial steel pipe";

//Properties of water determined at 20 C
parameter Real Rho(unit = "kg/m3") = 998 "Density of water";
parameter Real mu(unit = "kg/m.s") = 1.002*0.001 "Dynamic viscosity of water";

//=================
//Variable Section 
Real v(unit = "m3/s") "Total Volume flow rate";
Real v1(unit = "m3/s") "Volume flow rate in 1";
Real v2(unit = "m3/s") "Volume flow rate in 2";
Real h_pump(unit = "m") "Height of pump";
Real h_L(unit = "m") "Head loss";
Real V1(unit = "m/s") "Velocity in pipe-1";
Real V2(unit = "m/s") "Velocity in pipe-2";
Real Re1(unit = "-") "Reynolds number across pipe-1";
Real Re2(unit = "-") "Reynolds number across pipe-2";
Real f1(unit = "-") "Friction factor-1";
Real f2(unit = "-") "Friction factor-2";
Real h_L1(unit = "m") "Head loss in 1";
Real h_L2(unit = "m") "Head loss in 2";
String Flow;

//=================
//Equation Section
equation 
W*10^3 = (Rho*v*g*h_pump)/(eff/100);
//Multiplying W by 10^3 to convert kW to W

h_pump = (z_B-z_A)+h_L;
h_L = h_L1;
h_L = h_L2;
V1 = v1/((pi/4)*(D1*0.01)^2);
V2 = v2/((pi/4)*(D2*0.01)^2);
Re1 = (Rho*V1*D1*0.01)/(mu);
Re2 = (Rho*V2*D2*0.01)/(mu);

//Colebrook equation 
1/sqrt(f1)=-2*log10((((e*0.001)/(D1*0.01))/3.7)+(2.51/(Re1*sqrt(f1))));
1/sqrt(f2)=-2*log10((((e*0.001)/(D2*0.01))/3.7)+(2.51/(Re2*sqrt(f2))));

h_L1 = f1*(L/(D1*0.01))*((V1^2)/(2*g));
h_L2 = f2*(L/(D2*0.01))*((V2^2)/(2*g));
v = v1+v2;


//Verification of flow
if Re1>4000 and Re2>4000
then 
Flow = "Turbulent flow is verified";
else 
Flow = "Turbulent flow is not verified";
end if;

Modelica.Utilities.Streams.print(Flow); 

end Ex8_8;
//=================

