//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-9: Differential Analysis of Fluid Flow
//Example 9.2 Page 451
//Title: Design of a Compressible Converging Duct

package Ex9_2
model Ex9_2_a

//=================
//Parameter Section
parameter Real u_1(unit = "m/s") = 100 "Wind speed at section-1";
parameter Real u_2(unit = "m/s") = 300 "Wind speed at section-2";
parameter Real Rho_1(unit = "kg/m3") = 1.2 "Density of air at section-1";
parameter Real Rho_2(unit = "kg/m3") = 0.85 "Density of air at section-2";
parameter Real del_x(unit = "m") = 2 "Length of duct";
parameter Real h_1(unit = "m") = 2 "Height of duct at section-1";

//=================
//Variable Section 
Real Cu(unit = "1/s") "Constant-1 in expression";
Real Cp(unit = "kg/m4") "Constant-2 in expression";


//=================
//Equation Section
equation 
Cu = (u_2-u_1)/del_x;
Cp = (Rho_2-Rho_1)/del_x;

//Followed by derivation y-component of velocity

end Ex9_2_a;


//=================

model Ex9_2_b
extends Ex9_2_a;

//=================
//Parameter Section

//Input data from question
parameter Real [4] x(each unit = "m") = {0.5,1,1.5,2} "Domain";
parameter Real [4] y(each unit = "m") = {0.5,1,1.5,2} "Domain";

//=================
//Variable Section 
Real [4] Cu_b(each unit = "s^-1") "Array of Component to plot various stream lines";
Real [4] v(each unit = "m/s") "Velocity component";

//=================
//Equation Section
equation 
//To plot several streamlines

for i in 1:4 loop
Cu_b[i] = (u_2-u_1)/x[i];
v[i] = ((-((Rho_1*Cu_b[i])+(u_1*Cp))*y[i])-(2*Cu_b[i]*Cp*x[i]*y[i]))/((Rho_1)+(Cp*x[i]));
end for;

end Ex9_2_b;

//=================

end Ex9_2;

//=================
