// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 10 Law Of Hydrostatics
// Illustrative Example 10.1 Page Number 98
// Title - Pressure exerted on the bottom of the column
//========================================================================
model Ex10_1
//////Parameter section///////////////////////
//============================================
    parameter Real rho(unit="lb/ft^3")=848.7      "Density of mercury";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.2  "Conversion constant";
    parameter Real g(unit="ft/s^2")=32.2          "Acceleration  due to gravity";
    parameter Real h(unit="ft")=2.493             "Height of the mercury column";
    parameter Real Pa(unit="psf")=2116            "Atmospheric pressure";
//============================================= 
///////Variable section///////////////////////////
    Real Pg(unit="psf")                           "Gauge pressure ";
    Real P(unit="psfa")                           "Absolute Pressure ";
//============================================== 
//Equation Section
equation
    Pg=rho*(g/gc)*h;
    P=Pg+Pa;
end Ex10_1;
//============================================================================
