// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 10 Law Of Hydrostatics
// Illustrative Example 10.3 Page Number 99
// Title - Calculate the force on the bottom of the column
//========================================================================
model Ex10_3
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi    "The value of pi";
    parameter Real SG=0.89                          "Specific gravity of oil";
    parameter Real rho_w(unit="kg/m^3")=1000        "Density of water";
    parameter Real z1(unit="m")=0                   "Depth at point 1";
    parameter Real P1(unit="atm")=1                 "Pressure at point 1";
    parameter Real z2(unit="m")=-10.98              "Depth at point 2";
    parameter Real g(unit="m/s^2")=9.807            "Acceleration due to gravity";
    parameter Real z3(unit="m")=-13.72              "Depth at point 3";
    parameter Real D(unit="m")=6.1                  "Diameter of the tank";
//============================================= 
///////Variable section///////////////////////////    
    Real P2g(unit="Pag")                          "Gauge pressure at point 2";
    Real P3g(unit="Pag")                          "Gauge pressure at point 3";
    Real S(unit="m^2")                            "Cross sectional area";
    Real Fs(unit="N")                             "Force at the side of the tank";
    Real F(unit="N")                              "Force on the bottom of the tank";
    Real rho_oil(unit="kg/m^3")                   "Density of the oil";
//============================================== 
//Equation Section
equation
    rho_oil=SG*rho_w;
    P2g=rho_oil*g*(z1-z2);//Applying Bernoulli's  equation between point 1 and 2
    P3g=P2g+(rho_w*g*(z2-z3));
    S=(pi/4)*(D^2);
    F=(P3g+101325)*S;
    Fs=6.1*pi*((-11910*(z2-z3))-(4903.5*(((z2^2)-(z3^2)))));
end Ex10_3;
//Remark: The answer in the textbook for P2g is wrong.Calculation error.
//============================================================================
