// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 10 Law Of Hydrostatics
// Illustrative Example 10.4 Page Number 102
// Title - Volume of the displaced fluid
//========================================================================
model Ex10_4
//////Parameter section///////////////////////
//============================================
  parameter Real Wa(unit="lbf")=200          "Weight of the material in air";
  parameter Real Ww(unit="lbf")=120          "Weight of the material in water";
  parameter Real gamma(unit="lbf/ft^3")=62.4"Specific weight";
//============================================= 
///////Variable section///////////////////////////
  Real Fb(unit="lbf")                      "Buoyant force";
  Real V(unit="ft^3")                      "Volume displaced";
  Real rho(unit="kg/m^3")                  "Density of the block";
//============================================== 
//Equation Section
equation
    Fb=Wa-Ww;
    V=Fb/gamma;
    rho=(Wa/V)*16.0185;//Conversion of lb/ft^3 to kg/m^3
//Assumption that the density of the block is greater than density of the water holds good.
end Ex10_4;
//============================================================================


