// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 11 Ideal gas law 
// Illustrative Example 11.2 Page Number 113
// Title - Density of gas
//========================================================================
model Ex11_2
//////Parameter section///////////////////////
//============================================
    parameter Real P(unit="atm")=1               "Given pressure";
    parameter Real T(unit="degF")=60             "Given Temperature";
    parameter Real MW(unit="lb/lbmol")=29        "Molecular weight";
    parameter Real R(unit="atm.ft^3/lbmol.degR")=0.73"Gas constant";
//============================================= 
///////Variable section///////////////////////////
    Real rho(unit="lb/ft^3")                     "Density of the gas";
//============================================== 
//Equation Section
equation
  rho=(P*MW)/(R*(T+460));//Temperature  converted from degF to degR
end Ex11_2;
//============================================================================


