// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc., USA, 2009.
// Edition : 1
// Chapter : 11 Ideal gas law 
// Illustrative Example 11.5 Page Number 116
// Title - Molecular weight of a gas
//========================================================================
model Ex11_5
//////Parameter section///////////////////////
//============================================
    parameter Real  V_m(unit="ft^3/lb")=12.084            "Specific volume";
    parameter Real  T(unit="degF")=70                     "Given temperature";
    parameter Real  P(unit="atm")=1                       "Given pressure";
    parameter Real  R(unit="atm.ft^3/lbmol.degR")=0.73    "Gas constant";
//============================================= 
///////Variable section///////////////////////////
    Real MW                                               "Molecular weight" ;
//============================================== 
//Equation Section
equation
  V_m=(R*(T+460))/(P*MW);//Temperature converted from degF to degR.
end Ex11_5;
//============================================================================
