// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 12 Flow mechanisms 
// Illustrative Example 12.1 Page Number 124
// Title - Outlet Diameter of the duct
//========================================================================
model Ex12_1
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi "The value of pi";
  parameter Real T1(unit="degR")=660           "Inlet temperature";
  parameter Real D1(unit="ft")=6               "Inlet diameter";
  parameter Real v1(unit="ft/s")=25            "Inlet velocity";
  parameter Real T2(unit="degR")=2360          "Outlet temperature";
  parameter Real v2(unit="ft/s")=40            "Outlet velocity";
//============================================= 
///////Variable section///////////////////////////
  Real D2(unit="ft")         "Outlet diameter";
  Real A1(unit="ft^2")       "Inlet cross sectional area";
  Real q1(unit="ft^3/s")     "Volumetric flow rate at the inlet";
  Real q2(unit="ft^3/s")     "Volumetric flow rate at the outlet";
  Real A2(unit="ft^2")       "Outlet cross sectional area";
//============================================== 
//Equation Section
equation
  A1=pi*(D1^2)/4;
  q1=A1*v1;
  q2=q1*(T2/T1);//As per Charles Law
  A2=q2/v2;
  D2=(4*A2/pi)^0.5;
end Ex12_1;
//============================================================================

  
 

