// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 13 Laminar flow in pipes  
// Illustrative Example 13.4 Page Number 138
// Title - Maximum velocity of air
//========================================================================
model Ex13_4
//////Parameter section///////////////////////
//============================================
  parameter Real w(unit="m")=1            "Width of the rectangular section";
  parameter Real h(unit="m")=0.25         "Height of the rectangular section";
  parameter Real Re=2300                  "Critical Reynolds number";
  parameter Real neu(unit="m^2/s")=1E-5   "Kinematic viscosity" ;
//============================================= 
///////Variable section///////////////////////////
  Real v(unit="cm/s")                                "Maximum velocity of the fluid";
  Real Dh(unit="m")                                  "Equivalent diameter";
//============================================== 
//Equation Section
equation
  Dh=2*w*h/(w+h);
  v=(Re*neu/Dh)*100;//Conversion from m to cm
end Ex13_4;
//============================================================================


