// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 13 Laminar flow in pipes 
// Illustrative Example 13.6 Page Number 140
// Title - Velocity Distribution
//========================================================================
model Ex13_6
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi     "The value of pi";
  parameter Real rho(unit="kg/m^3")=1260           "Density of the fluid" ;
  parameter Real meu(unit="kg/m.s")=1.49           "Viscosity of the fluid";
  parameter Real R(unit="m")=0.02                  "Radius at no slip boundary condition";
  parameter Real r(unit="m")=0                     "Radial distance at the average velocity";
//============================================= 
///////Variable section///////////////////////////
  Real vav(unit="m/s")                         "Average velocity";
  Real v_noslip(unit="m/s")                    "Velocity at no slip boundary condition";
  Real q(unit="m^3/s")                         "Volumetric flow rate " ;
  Real neu(unit="m^2/s")                       "Kinematic viscosity";
  Real m(unit="kg/s")                          "Mass flow rate";
  Real G(unit="kg/m^2.s")                      "Mass flux";
  Real M(unit="N")                             "linear momentum flux";
//============================================== 
//Equation Section
equation
  neu=meu/rho;
  v_noslip=16*(1-(2500*R^2));
  q=pi*32*((R^2/2)-((2500/4)*(R^4)));
  vav= 16*(1-(2500*r^2))/2;
  m=q*rho;
  G=rho*vav;
  M=m*vav;
end Ex13_6;
//============================================================================



