// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 13 Laminar flow in pipes 
// Illustrative Example 13.7 Page Number 142
// Title - Time taken for the liquid to pass the cross sectional area
//========================================================================
model Ex13_7
//////Parameter section///////////////////////
//============================================
  parameter Real rho(unit="kg/m^3")=1260    "Density of the fluid";
  parameter Real v(unit="m/s")=8            "Velocity of the fluid";
  parameter Real D(unit="m")=0.02           "Diameter of the pipe";
  parameter Real meu(unit="kg/m.s")=1.49    "Viscosity of the fluid";
  parameter Real V(unit="gallons")=14000    "Volume of the liquid";
  parameter Real q(unit="gpm")=159.6"Volumetric flow rate";
//============================================= 
///////Variable section///////////////////////////
  Real t(unit="min")                         "Time taken for the liquid to pass the cross sectional area";
  Real Re                                    "Reynolds number";
//============================================== 
//Equation Section
equation
  Re=rho*v*D/meu;//As Re < 2100 The flow is Laminar
  t=V/q;
end Ex13_7;
//============================================================================




