// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 15 Compressible and sonic flow 
// Illustrative Example 15.6 Page Number 173
// Title - Natural gas flowing through a pipe
//========================================================================
model Ex15_6
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi   "The value of pi";
    parameter Real q(unit="scfs")=236              "Volumetric flow rate";
    parameter Real D(unit="ft")=1                  "Diameter of the pipe";
    parameter Real P(unit="psia")=89.7             "Pressure";
    parameter Real T(unit="degR")=530              "Tempertaure";
    parameter Real MW(unit="lb/lbmol")=16          "Moleclar weight of the natural gas";
    parameter Real R(unit="psi.ft^3/lbmol.degR")=10.73"Gas constant";
    parameter Real f=0.008                          "Friction factor";
    parameter Real L(unit="miles")=3                "Length of the pipe";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.2    "Conversion constant";
    parameter Real P1(unit="psia")=89.7             "Inlet pressure";
///////Variable section///////////////////////////
//==============================================     
    Real m(unit="lb/s")                            "Mass flow rate";
    Real P2(unit="psia")                           "Outlet pressure";
    Real Pdrop(unit="psf")                         "Pressure drop";
    Real rho(unit="lb/ft^3")                       "Density of the fluid";
    Real G(unit="lb/ft^2.s")                       "Mass velocity  flux"; 
    Real DelP(unit="psia")                         "Recalculated pressure drop";
//============================================= 
//Equation Section
equation
  m=q*MW/379;//To obtain mass flow rate Dividing by the molar volume.
  G=m/(pi*D^2/4);
  rho=P*MW/(R*T);
  Pdrop=(2*f*L*5280*(G^2))/(gc*rho*D);//Converting miles to ft
  P2=P1-(Pdrop/144);//Converting Pdrop from psf to psia.
  DelP=P1-P2;
end Ex15_6;
//============================================================================

