// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 16 Two phase flow 
// Illustrative Example 16.4 Page Number 187
// Title - Total Pressure Drop
//========================================================================
model Ex16_4
//////Parameter section///////////////////////
//============================================
  parameter Real X=1.66                         "Dimensionless Parameter";
  parameter Real DelP_zG(unit="psft/100ft")=2.71"Pressure Drop per 100 ft  for the gas";
  parameter Real DelP_zL(unit="psft/100ft")=7.50"Pressure Drop per 100 ft  for the Liquid";
//============================================= 
///////Variable section///////////////////////////
  Real YG_vv                                  "Function of the variable X for gas";
  Real DelP_Z(unit="psf/100 ft")              "Pressure Drop per 100 ft from YG";
  Real DELP_Z(unit="psf/100 ft")              "Pressure Drop per 100 ft from YL";
  Real YL_vv                                  "Function of the variable X for liquid";
//============================================== 
//Equation Section  
equation
  YG_vv=10-(10.405*X)+(8.6786*X^2)-(0.9167*X^3);//As per equation 16.22b
  DelP_Z=YG_vv*DelP_zG;
  YL_vv=6.4699*(1/(X^0.556));//As per equation 16.23b
  DELP_Z=YL_vv*DelP_zL;
end Ex16_4;
//============================================================================
