//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009. 
// Edition : 1
// Chapter : 17 Prime movers 
// Illustrative Example 17.1 Page Number 201
// Title - Required power for the fan
//========================================================================
model Ex17_1
//////Parameter section///////////////////////
//============================================
    parameter Real Da(unit="in")=46      "Diameter of the blade A";
    parameter Real rpma(unit="rpm")=1575 "Speed of the fan A";
    parameter Real Db(unit="in")=42      "Diameter of the balde B";
    parameter Real rpmb(unit="rpm")=1625 "Speed of the fan B";
    parameter Real hpa(unit="bhp")=47.5  "Power required by Fan A to transport the fluid";
//============================================= 
///////Variable section///////////////////////////    
    Real hpb(unit="bhp")                 "Power required by Fan B to transport the fluid";
//============================================== 
//Equation Section    
equation
    hpb=((rpmb/rpma)^3)*((Db/Da)^5)*(hpa);
end Ex17_1;
//============================================================================ 
