//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009. 
// Edition : 1
// Chapter : 17 Prime movers 
// Illustrative Example 17.3 Page Number 205
// Title - Horse power required to process a gas
//========================================================================
model Ex17_3
//////Parameter section///////////////////////
//============================================= 
    parameter Real Del_P(unit="in H2O")=4.4"Pressure Loss across elbows,valves ,etc";
    parameter Real Del__P(unit="in H2O")=6.4"Pressure drop accross various units";
    parameter Real q(unit="acfm")=6500     "Volumetric flow rate";
    parameter Real neta=0.63               "Efficiency";
//============================================= 
///////Variable section///////////////////////////
    Real bhp(unit="bhp")                   "Brake hoursepower required";
    Real DelP(unit="in H2O")               "Total pressure drop";
//============================================== 
//Equation Section
equation
    DelP=Del_P+Del__P;
    bhp=1.575E-4*q*DelP/neta;//Conversion factor is used to obtain hp
end Ex17_3;
//============================================================================
