// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 17 Prime movers 
// Illustrative Example 17.8 Page Number 216
// Title - Power requirement
//========================================================================
model Ex17_8
//////Parameter section///////////////////////
//============================================
  parameter Real T1(unit="degR")=520             "Temperature of atmospheric air";
  parameter Real P2(unit="psia")=40              "Pressure at the nozzle";
  parameter Real P1(unit="psia")=14.7            "Pressure of atmospheric air";
  parameter Real R(unit="Btu/lbmol.degR")=1.987  "Gas constant";
  parameter Real gamma=1.3"Ratio of heat capacity at constant pressure to that at constant volume";
  parameter Real m(unit="lb/min")=7.5            "Mass flow rate";
  parameter Real MW(unit="lb/lbmol")=29          "Molecular weight of air";
//============================================= 
///////Variable section///////////////////////////
  Real Ws(unit="Btu/lbmol of air")"Compressed energy requirement";
  Real hp(unit="ft.lbf/min")"Power required";
//============================================== 
//Equation Section
equation
  Ws=(-gamma*R*T1/(gamma-1))*((P2/P1)^((gamma-1)/(gamma))-1);
  hp=Ws*(m/MW)*778;//Conversion of Btu to ft.lbf
end Ex17_8;
// Remark: Printing mistake in the book for the value of hp.
//============================================================================


