// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 18 Valves and Fittings
// Illustrative Example 18.4 Page Number 229
// Title - Frictional Loss due to the fitting
//========================================================================
model Ex18_4
//////Parameter section///////////////////////
//============================================
  parameter Real Kf=22                        "Loss coefficient";
  parameter Real v(unit="ft/s")=10            "Velcoity of the fluid";
  parameter Real gc(unit="lb.ft/lbf.s^2")=32.2"conversion constant";
//============================================= 
///////Variable section///////////////////////////
  Real hf(unit="ft.lbf/lb")                    "Frictional Loss for the fitting";
//============================================== 
//Equation Section
equation
  hf=Kf*(v^2)/(2*gc);
end Ex18_4;
//============================================================================


