// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 18 Valves and Fittings
// Illustrative Example 18.6 Page Number 230 
// Title - Volumetric flow rate 
//========================================================================
model Ex18_6
//////Parameter section///////////////////////
//============================================
  final constant Real pi=Modelica.Constants.pi "The value of pi";
  parameter Real k(unit="ft")=0.00085          "Roughness factor";
  parameter Real D(unit="ft")=0.833            "Diameter of the pipe";
  parameter Real f=0.005                       "Fanning Friction factor";
  parameter Real K=0.45                        "Entrance Loss coefficient";
  parameter Real L(unit="ft")=5000             "Length of the pipe";
  parameter Real g(unit="ft/s^2")=32.2         "Acceleration due to gravity";
  parameter Real h(unit="ft")=260              "Height  difference between z1 and z2";
  parameter Real neu(unit="ft^2/s")=1.082E-5   "kinematic viscosity of the fluid";
//============================================= 
///////Variable section///////////////////////////
  Real v2(unit="ft/s")                       "Velocity of the fluid at position 2";
  Real Re                                    "Reynolds number";
  Real q(unit="ft^3/s")                      "Volumetric flow rate";
  Real k_D                                   "Relative Roughness";
//============================================== 
//Equation Section
equation
  k_D=k/D;
  (h*2*g)=v2^2*((4*f*L/D)+K+1);//Applying Bernoulli's equation between point 1 and 2
  Re=(D*v2)/neu;
  q=v2*pi*(D^2)/4;
end Ex18_6;
//============================================================================


