// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 18 Valves and Fittings
// Illustrative Example 18.8 Page Number 233
// Title - Pump power required
//========================================================================
model Ex18_8
//////Parameter section///////////////////////
//============================================
  parameter Real rho(unit="kg/m^3")=1000 "Density of the fluid";
  parameter Real g(unit="m/s^2")=9.807   "Acceleration due to gravity";
  parameter Real hf(unit="m")=38.39      "Head Loss";
  parameter Real q(unit="m^3/s")=0.0126  "Volumetric flow rate";
//============================================= 
///////Variable section///////////////////////////
  Real DelP(unit="Pa")                   "Pressure drop";
  Real Ws(unit="kW")                     "Pumping power";
//============================================== 
//Equation Section
equation
  DelP=rho*g*hf;
  Ws=q*DelP;
end Ex18_8;
//Remark: The  answer provided in the textbook for Ws is wrong.Calculation error.
//============================================================================

