// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 19 Flow measurment
// Illustrative Example 19.6 Page Number 255
// Title - Volumetric flow rate
//========================================================================
model Ex19_6
//////Parameter section///////////////////////
//============================================
   final constant Real pi=Modelica.Constants.pi            "the value of pi" ;
   parameter Real D2(unit="m")=0.02                        "Diameter at the throat";
   parameter Real D1(unit="m")=0.06                        "The upstream diameter";
   parameter Real P1(unit="Pa")=101325                     "Upstream pressure";
   parameter Real P2(unit="Pa")=50000             "Vapour pressure which will cause cavitation";
   parameter Real rho(unit="kg/m^3")=680                   "Density of gasoline";
//=============================================== 
///////Variable section///////////////////////////
  Real v2(unit="m/s")            "Velocity  at  the throat";
  Real q(unit="m^3/s")           "Volumetric flow rate";
//========================================================================= 
//Equation Section
equation
    v2=((2*(P1-P2))/(rho*(1-((D2/D1)^4))))^0.5;//As per the equation 19.14
    q=v2*pi*(D2^2)/4;//Printing mistake in the book
end Ex19_6;
//============================================================================
