// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 19 Flow measurment
// Illustrative Example 19.7 Page Number 258
// Title - Pressure drop across the orfice plate
//========================================================================
model Ex19_7
//////Parameter section////////
//==================================
 final constant Real pi=Modelica.Constants.pi        "the value of pi";
 parameter Real D2(unit="m")=0.19                    "Orifice diameter";
 parameter Real rho(unit="kg/m^3")=1.23              "Density of air";
 parameter Real rho_m(unit="kg/m^3")=1000            "Density of water"; 
 parameter Real meu(unit="kg/m.s")=1.8E-5            "Viscosity of air";
 parameter Real D1(unit="m")=0.25                    "Diameter of the circular duct";
 parameter Real q(unit="m^3/s")=1                    "Volumetric flow rate";
 parameter Real Co_act=0.62                          "Actual discharge coefficient fom fig 19.18";
 parameter Real Co=1                                 "Discharge coefficient";
//================================= 
///////Variable section/////////
 Real P_rec                          "Percentage pressure recovery";
 Real P_Loss                         "Percentage pressure loss";
 Real v2(unit="m/s")                 "Velocity though the orifice";
 Real Re                             "Renyolds number";
 Real DelP(unit="Pa")                "Pressure Loss";
 Real DelPact(unit="Pa")             "Actual pressure Loss";
 Real DelP_L(unit="Pa")              "Actual Pressure Loss in the orfice meter after recovery";
//=================================== 
//////////Equation Section///////
equation
  q=v2*pi*(D2^2)/4;
 v2=(((2*(DelP))/(rho*(1-((D2/D1)^4))))^0.5)*Co;//Assuming that Co=1.Using eqn 19.20
 Re=v2*D2*rho/meu;
 v2=(((2*(DelPact))/(rho*(1-((D2/D1)^4))))^0.5)*Co_act;
 P_rec=(14*(D2/D1))+(80*((D2/D1)^2));//As per the equation 19.22
 P_Loss=100-P_rec;
 DelP_L=(P_Loss/100)*DelPact;
end Ex19_7;
//======================================
