// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 20 Ventilation
// Illustrative Example 20.3 Page Number 270
// Title - Maximum H2S concentration 
//========================================================================
model Ex20_3
//////Parameter section///////////////////////
//============================================  
    parameter Real MwH2S(unit="lb/lbmol")=34                    "Molecular  weigth of H2S";
    parameter Real Mwair(unit="lb/lbmol")=29                    "Molecular  weigth of air";
    parameter Real Vr(unit="ft^3")=1600                        "Volume of  the room";
    parameter Real n_H2SO4(unit="lbmol")=0.010                  "Moles of H2SO4";
    parameter Real s1=3                                         "Stoichiometric coefficient of H2SO4";
    parameter Real s2=3                                         "Stoichiometric coefficient of H2S";
    parameter Real Tr(unit="degF")=51                           "Temperature of air in the room";
    parameter Real Tst(unit="degF")=32                          "Standard temperature";
    parameter Real vst(unit="ft^3")=359                        "Standard volume";
//============================================= 
///////Vriable section///////////////////////////     
    Real V(unit="ft^3")                                       "Volume of ideal gas at 51 degF";
    Real n_H2S(unit="lbmol")                                    "Moles of H2S";
    Real mH2S(unit="lb")                                        "Mass of H2S";
    Real C_H2S(unit="ppm")                                      "Concentration of H2S";
//============================================== 
//Equation Section    
equation
    n_H2S=n_H2SO4*(s2/s1);
    mH2S=n_H2S*MwH2S;
    V=vst*(460+Tr)/(460+Tst);//Converting degF to degR
    C_H2S=mH2S*(V/Mwair)*1E6/Vr;
end Ex20_3;
//=========================================================================
