// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 20 Ventilation
// Illustrative Example 20.4 Page Number 271
// Title - Vinyl chloride application
//========================================================================
model Ex20_4
//////Parameter section///////////////////////
//============================================
    parameter Real MW(unit="g/gmol")=78            "Molecular weight";
    parameter Real R(unit="cm^3.atm/mol.K")=82.06  "Gas constant";
    parameter Real T(unit="K")=298                 "Temperature";
    parameter Real P(unit="atm")=1                 "Pressure";
    parameter Real m(unit="g/min")=10              "Mass flow rate";
    parameter Real Sfac=10                         "Safety factor";
    parameter Real H(unit="in")=30                 "Height";
    parameter Real W(unit="in")=25                 "Width";
    parameter Real v(unit="ft/min")=100             "Velocity";
//============================================= 
///////Variable section///////////////////////////    
    Real qexh(unit="acfm")                        "Volumetric  flow rate of air";
    Real S(unit="ft^2")                            "Cross sectional area";
    Real q(unit="acfm")                           "Volumetric flow rate";
    Real rho(unit="g/cm^3")                       "Density of fluid";
    Real q_air(unit="acfm")                        "Volumetric flow rate of air";
    Real q_dil(unit="acfm")                        "Volumetric flow rate of dilution ventilation";
//============================================== 
//Equation Section    
equation
    rho=P*MW/(R*T);
    q=m/(rho*30.48^3);//Converting cm^3 to ft^3
    q_air=q/1E-6;
    q_dil=Sfac*q_air;
    S=H*W/144;//Conversion from in^2 to ft^2
    qexh=S*v;
end Ex20_4;
//=========================================================================
