// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.17 Page Number 292
// Title - Pressure drop  and the power requirement.
//========================================================================
model Ex21_17
//////Parameter section///////////////////////
//============================================
   parameter Real pi=Modelica.Constants.pi           "The value of pi";
  parameter Real H(unit="ft")=1                      "Height of the rectangle";
  parameter Real W(unit="ft")=2                      "Width of the rectangle";
  parameter Real P(unit="atm")=1                     "Pressure";
  parameter Real Mw(unit="lb/lbmol")=28.9            "Molecular weight of air";
  parameter Real R(unit="atm.ft^3/lbmol.degR")=0.7302"Gas constant";
  parameter Real T(unit="degF")=75                   "Temperature";
  parameter Real q(unit="cfm")=4800                  "Volumetric flow rate";
  parameter Real neu(unit="ft^2/s")=0.00016          "Kinematic Viscosity";
  parameter Real k(unit="ft")=0.00015                "Pipe roughness";
  parameter Real g(unit="ft/s^2")=32.174             "Acceleration due to gravity";
  parameter Real l(unit="ft")=1000                   "Length of the duct";
  parameter Real theta(unit="deg")=5                 "Angle at which the duct is inclined";
  parameter Real E=0.6"Efficiency";
//============================================= 
///////Variable section///////////////////////////
     Real Deq(unit="ft")           "Equivalent Diameter";
     Real rho(unit="lb/ft^3")      "Density of air";
     Real v(unit="ft/s")           "Flow velocity";
     Real Re                       "Reynolds number";
     Real k_D                      "Roughness ratio";
     Real f                        "Fanning friction factor";
     Real hf(unit="ft")            "Head Loss";
     Real Delz(unit="ft")          "Difference in the height";
     Real DelP(unit="psf")         "Pressure drop";
     Real Ws(unit="ft.lbf/s")      "Power requirement";
     Real bhp(unit="hp")           "Actual power requirement";
     Real percentLoss             "Percent Loss due to friction";
//============================================== 
//Equation Section
equation
    Deq=4*H*W/(2*(H+W));
    rho=P*Mw/(R*(T+460));//From ideal gas law
    v=(q/60)/(H*W);//Conversion from min to seconds
    Re=Deq*v/neu;//As Re > 2100 The flow is  turbulent
    k_D=k/Deq;
    f=0.00375;//Obtained from fig 14.2
    hf=4*f*l*(v^2)/(2*Deq*g);
    Delz=l*sin(theta*pi/180);
    DelP=rho*(hf+Delz);
    Ws=(q/60)*DelP;
    percentLoss=hf*100/(hf+Delz);
    bhp=Ws*0.001818/E;//Conversion from ft.lbf/s to hp 
end Ex21_17;
//Remark: The power requirement and percent loss  for this sum is printed in Pg No 275.Printing Error.
//============================================================================
