// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 21 Academic application
// Illustrative Example 21.8 Page Number 285
// Title - Reynolds number
//========================================================================
model Ex21_8
//////Parameter section///////////////////////
//============================================
    parameter Real rho(unit="lb/ft^3")=62.4                    "Density of the fluid";
    parameter Real meu(unit="lb/ft.s")=6.72E-4                 "Viscosity of the fluid";
    parameter Real q1(unit="gpm")=1.5                          "Volumetric flow rate";
    parameter Real q2(unit="gpm")=6                            "Volumetric flow rate";
    parameter Real D1(unit="in")=0.493                         "Diameter of the pipe";
    parameter Real D2(unit="in")=0.622                         "Diameter of the pipe";
//============================================= 
///////Variable section///////////////////////////
    Real v11(unit="ft/s")                                     "Velocity from 1.5 gpm for 3/8 in pipe";
    Real v12(unit="ft/s")                                     "Velocity from 6  gpm for 3/8 in pipe";
    Real v21(unit="ft/s")                                     "Velocity from 1.5 gpm for 1/2 in pipe";
    Real v22(unit="ft/s")                                     "Velocity from 6 gpm for 1/2 in pipe";
    Real Re12                                                 "Reynolds number for velocity v12";
    Real Re21                                                 "Reynolds number for velocity v21";
    Real Re22                                                 "Reynolds number for velocity v22";
    Real Re11                                                 "Reynolds number for velocity v11";
//============================================== 
//Equation Section
equation
//For 3/8 in Pipe 
    v11=(0.409*q1)/(D1^2);
    v12=(0.409*q2)/(D1^2);
    Re11=(D1/12)*v11*rho/meu;//Converting in to ft
    Re12=(D1/12)*v12*rho/meu;//Converting in to ft
//For 1/2 in Pipe
    v21=(0.409*q1)/(D2^2);
    v22=(0.409*q2)/(D2^2);
    Re21=(D2/12)*v21*rho/meu;//Converting in to ft
    Re22=(D2/12)*v22*rho/meu;//Converting in to ft
end Ex21_8;
// Remark: The value in the textbook for Re differs due to the approximation of v.
//============================================================================
