// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.10 Page Number 306
// Title -  NPSH of the pump
//========================================================================
model Ex22_10
//////Parameter section///////////////////////
//============================================
      final constant Real pi=Modelica.Constants.pi   "The value of pi";
      parameter Real q(unit="m^3/s")=0.003           "Volumetric flow rate";
      parameter Real D(unit="m")=0.03                "Diameter at the suction and discharge line";
      parameter Real g(unit="m/s^2")=9.807           "Acceleration due to gravity";
      parameter Real z1(unit="m")=0                  "Height at point 1";
      parameter Real z2(unit="m")=1.8                "Height at point 2";
      parameter Real rho(unit="kg/m^3")=865          "Density of benzene";
      parameter Real Pv(unit="Pa")=26200             "Vapour pressure";
      parameter Real NPSHm(unit="m")=8               "NSPH by manufacturer";
      parameter Real z3(unit="m")=1.8                "Height at point 3"; 
//============================================= 
///////Variable section///////////////////////////    
      Real v2(unit="m/s")                               "Velcoity at point 2";
      Real v3(unit="m/s")                               "Velocity at point 3";
      Real Dh(unit="m")                                 "Dynamic head";
      Real P3(unit="Pa")                                "Pressure at point 3";
      Real Pm_bz(unit="m")                              "Pressure in terms of height of benzene";
      Real P_n(unit="Pa")                               "New pressure at point 3";
      Real Z3(unit="m")                                 "Desired height at point 3";
      Real NPSH(unit="m")                               "Calculated NSPH";
//============================================== 
//Equation Section  
equation
    v2=q/((pi*D^2)/4);
    v3=v2;//As the diameters are all the same
    Dh=(v3^2)/(2*g);
    P3=101325-((z3+Dh)*rho*g);//Applying Bernoulli's equation between point 1 and 3
    NPSH=((P3-Pv)/(rho*g))+Dh;//As NPSHm > NSPH the suction point is to be lowered
    P_n=((NPSHm-Dh)*rho*g)+Pv;
    Pm_bz=(P_n-101325)/(rho*g);
    0=Z3+Pm_bz+Dh;//Applying Bernoullis equation to find z
end Ex22_10;
//========================================================================
