// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.11 Page Number 308
// Title -  Pumping power required for the process
//========================================================================
model Ex22_11
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi                "The value of pi";
    parameter Real q(unit="ft^3/s")=1.36                        "Volumetric flow rate";
    parameter Real D(unit="in")=4                               "Diameter of the pipe";
    parameter Real rho(unit="lb/ft^3")=62.37                    "Density of the fluid";
    parameter Real meu(unit="cP")=1.129                         "Viscosity of the fluid ";
    parameter Real L(unit="ft")=525                             "Length of the pipe";
    parameter Real gc(unit="lb.ft/lbf.s^2")=32.174              "Conversion factor";
    parameter Real K_gate=0.11                                  "Loss Coefficient due to gates";
    parameter Real K_elbow=0.64                                 "Loss coefficient due to elbow";
    parameter Real D1_D2=0                                      "Ratio of D1 to D2";
    parameter Real v1(unit="ft/s")=0                            "Velocity at point 1";
    parameter Real Z2(unit="ft")=200                            "Height at point 2";
    parameter Real Z1(unit="ft")=0                              "Height at point 1";
    parameter Real neta=0.6                                     "Efficiency";
    parameter Real k(unit="in")=0.0018                          "Pipe roughness";
//============================================= 
///////Variable section///////////////////////////    
    Real k_D"Roughness ratio";    
    Real v(unit="ft/s")                                   "Pipe velocity";
    Real Re                                               "Reynolds Number";
    Real f                                                "Friction factor";
    Real v2(unit="ft/s")                                  "Velocity at point 2";
    Real hf(unit="ft.lbf/lb")                             "Frictional Loss";
    Real Kff_gate                                         "Loss Coefficient due to 2 gates";
    Real Kff_elbow                                        "Loss coefficient due to 5 elbows";
    Real Kc                                               "Loss coefficient due to sudden contraction";
    Real Ke                                               "Loss coefficient due to sudden expansion";
    Real K                                                "Sum of all Loss coefficient";
    Real hf_fittings(unit="ft.lbf/lb")                    "Loss due to the fittings";
    Real hf_total(unit="ft.lbf/lb")                       "Total Frictional Loss";
    Real m(unit="lb/s")                                   "Mass flow rate";
    Real Ws(unit="ft.lbf/lb")                             "Power requirement in order to move the fluid";
    Real Ws_dot(unit="hp")                                "Actual Horse power requirement";
    Real Ws_kW(unit="kW")                                 "Power in kW";
//============================================== 
//Equation Section
equation
    v=q/(pi*((D/12)^2)/4);
    Re=D*v*rho/(12*meu*6.72E-4);//As Re > 2100 The flow is turbulent.
    k_D=k/D;
    f=0.0046;//From Fig 14.2
    hf=(4*f*L*(v^2)*12)/(D*2*gc);
    Kff_elbow=K_elbow*5;//Loss Coeffcient for 5 elbows
    Kff_gate=K_gate*2;//Loss Coeffcient for 2 gates
    Kc=0.42*(1-(D1_D2));
    Ke=(1-((D1_D2)^4));
    K=Ke+Kc+Kff_gate+Kff_elbow;
    hf_fittings=(K*(v^2))/(2*gc);
    hf_total=hf_fittings+hf;
    v2=v;
    (((v2^2)-(v1^2))/(2*gc))+(Z2-Z1)+hf_total=(Ws);//Applying Bernoulli's equation where DelP =0
    m=q*rho;
    Ws_dot=m*Ws/(neta*550);
    Ws_kW=Ws_dot*0.7457;//Conversion of hp to kW
end Ex22_11;
//Remark: The Loss coefficient Kff_elbow and Kff_gate are dimensionless.Printing mistake in the units in the book. 
//========================================================================
