// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.13 Page Number 313
// Title -  Friction Loss
//========================================================================
model Ex22_13
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi            "The value of pi";
    parameter Real rho(unit="kg/m^3")=0.0838                "Density of the fluid";
    parameter Real meu(unit="kg/m.s")=9.05E-6               "Viscosity of the fluid";
    parameter Real D(unit="m")=0.08                         "Diameter of the pipe";
    parameter Real q(unit="m^3/s")=0.0004                   "Volumetric flow rate";
    parameter Real g(unit="m/s^2")=9.807                    "Acceleration due to gravity";
    parameter Real L(unit="m")=1                            "Length of the pipe";
    parameter Real r[3](each unit="m")={0,0.02,0.04}        "Radius of the pipe";
//============================================= 
///////Variable section///////////////////////////  
    Real S(unit="m^2")                                      "Cross sectional area";    
    Real m(unit="kg/s")                                     "Mass flow rate";
    Real v(unit="m/s")                                      "Velocity of the fluid";
    Real DelP_L(unit="Pa/m")                                "Pressure gradient";
    Real v_max(unit="m/s")                                  "Maximum velocity";
    Real f                                                  "Fanning friction factor";
    Real f_d                                                "Darcy friction factor";
    Real hf(unit="m")                                       "Friction loss";
    Real Wf(unit="W")                                       "Friction power loss";
    Real Re                                                 "Reynolds number";
    Real v_r[3](each unit="m/s")                            "Veloclty at each r";
//============================================== 
//Equation Section    
equation
    S=pi*D^2/4;
    m=rho*q;
    v=q/S;
    Re=(D*rho*v)/meu;//As it is less than 2100 It is Laminar.
    DelP_L=(128*meu*q)/(pi*(D^4));
    v_max=2*v;
//Using parabolic velocity equation determing velocity at various r.
    for i in 1:3 loop
    v_r[i]=v_max*(1-((r[i]/0.04)^2));
    end for;
    f=16/Re;
    f_d=4*f;
    hf=(4*f*L*(v^2))/(D*2*g);
    Wf=(m*g*hf);
end Ex22_13;
//Remark: The  answer provided in the textbook is wrong for S.Printing error. Hence the answer differs.
//========================================================================
