// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.4 Page Number 298
// Title - Impeller Diameter of the centrifugal pump
//========================================================================
model Ex22_4
//////Parameter section///////////////////////
//============================================
   final constant Real pi=Modelica.Constants.pi        "The value of pi";
   parameter Real h(unit="ft")=200                     "Develeped head";
   parameter Real g(unit="ft/s^2")=32.2                "Accelaration due to gravity";
   parameter Real N(unit="rpm")=1800                   "Pump  is operating at this rorational speed"; 
//============================================= 
///////Variable section///////////////////////////    
   Real c(unit="ft/rotation")                          "Number of feet the impeller moves in one rotation";
   Real D(unit="ft")                                   "Impeller Diameter";
   Real v(unit="ft/s")                                 "Velocity needed to develop 200ft";
//============================================== 
//Equation Section
equation
    (v^2)=2*h*g;
    c=v*60/N;//Converting minutes to seconds
    D=c/pi;
end Ex22_4;
//=============================================================================
