// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 22 Industrial Applications
// Illustrative Example 22.5 Page Number 299
// Title - Total energy required
//========================================================================
model Ex22_5
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi        "The value of pi";
    parameter Real rho(unit="kg/m^3")=998               "Density of the fluid";
    parameter Real meu(unit="N.s/m^2")=0.001            "Viscosity of the fluid";
    parameter Real D(unit="m")=0.15                     "Diameter of pipe";
    parameter Real L(unit="m")=120                      "Length of pipe";
    parameter Real q1(unit="m^3/min")=1.2               "Volumetric flow rate";
    parameter Real k=0.0005                             "Roughness factor for galvanised iron";
    parameter Real g(unit="m/s^2")=9.81                 "Acceleration due to gravity";
    parameter Real Delz(unit="m")=22                    "Difference in height";
    parameter Real K_elb=0.5                            "Loss coefficient of a single elbow";
//============================================= 
///////Variable section/////////////////////////// 
    Real S(unit="m^2")                                  "Cross sectional area";
    Real q(unit="m^3/s")                                "Volumetric flow rate";
    Real v(unit="m/s")                                  "Velocity";
    Real K                                              "Loss coefficient due to the 8 elbows";
    Real k_D                                            "Roughness ratio";
    Real f                                              "Friction factor";
    Real hf(unit="J")                                   "Friction loss of energy";
    Real VH(unit="J/kg")                                "Velocity head";
    Real TotalLoss(unit="J/kg")                         "Total Loss from the elbows";
    Real DelPE(unit="J/kg")                             "Energy to move 1 kg water";
    Real Etot(unit="J/kg")                              "Total energy requirement";
    Real Ws(unit="J/s")                                 "Theoretical power requirement";
    Real head(unit="m of water")                        "Head developed";
    Real Re                                             "Renyolds number";
//============================================== 
//Equation Section
equation
    S=(pi/4)*(D^2); 
    q=q1/60;
    v=q/S;
    Re=(D*v*rho)/meu;//As Re >2100 The flow is turbulent
    k_D=k/D;
    f=0.0053;//From the Fig14.2;
    hf=(4*f*L*(v^2))/(2*D);
    VH=(v^2)/2;
    K=8*K_elb;//For 8 Elbows Determinig the value of K
    TotalLoss=K*VH;
    DelPE=Delz*g;
    Etot=DelPE+TotalLoss+hf;
    Ws=Etot*q*rho;
    head=Etot/g;
//Remark: The answer given in the book for Re is 1.7E5 Round off error in v.  
end Ex22_5;
//=============================================================================
