// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 23 Particle dynamics 
// Illustrative Example 23.7 Page Number 340
// Title - Average height of soap particles
//========================================================================
model Ex23_7
//////Parameter section///////////////////////
//============================================
    parameter Real Dp(unit="ft")=3.28E-3                "Diameter of large particle";
    parameter Real g(unit="ft/s^2")=32.174              "Acceleration due to gravity";
    parameter Real sg=0.8                               "Specific gravity";
    parameter Real rho_w(unit="lb/ft^3")=62.4           "Density of water";
    parameter Real rho_a(unit="lb/ft^3")=0.0752         "Density of atmosphere";
    parameter Real meu(unit="lb/ft.s")=1.18E-5          "Viscosity of the fluid";
    parameter Real H(unit="ft")=400                     "Vertical height";
    parameter Real dp(unit="ft")=6.89E-6                "Diameter of the smallest particle";
    parameter Real m(unit="tons")=100                   "Mass of the particle";
    parameter Real e=0.5                                "Void fraction";
    parameter Real W(unit="ft")=100                     "Width";
    parameter Real v_w(unit="miles/h")=20               "Wind velocity";
    parameter Real g_acc(unit="ft/s^2")=32.2            "Aproximated value of g";
///////Variable section///////////////////////////
//==============================================
    Real Kl                                             "Criterion for settling for largest particle";
    Real rho_p(unit="lb/ft^3")                          "Diameter of the particle";
    Real vs(unit="ft/s")                                "Terminal setlling Velocity of the small particle";
    Real tl(unit="s")                                   "Descent time for the large particle";
    Real L(unit="ft")                                   "Horizontal distance for the large particle";
    Real Ks                                             "Criterion for settling for small particle";
    Real ts(unit="s")                                   "Descent time for the small particle";
    Real Ls(unit="ft")                                  "Horizontal distance traveled for small particle";
    Real Vact(unit="ft^3")                              "Actual volume of the particle";
    Real Vb(unit="ft^3")                                "Bulk volume";
    Real Ld(unit="ft")                                  "Length of the drop area";
    Real A(unit="ft^2")                                 "Deposition area";
    Real Hdep(unit="ft")                                "Deposition height";
    Real v(unit="ft/s")                                 "Terminal settling velocity of the large particle";
//============================================= 
 //Equation Section
equation
    rho_p=sg*rho_w;
//Calculation for the largest particle
    Kl=Dp*(((g*(rho_p-rho_a)*rho_a)/(meu^2))^(1/3));//As 43.6>K >3.3 The intermediate regime applies
    v=0.153*((((g_acc^0.71)*(rho_p^0.71))*(Dp^1.14))/((meu^0.43)*(rho_a^0.29)));
    tl=H/v;
    L=tl*v_w*(5280/3600);//Converting miles/h to ft/s
//Calculation for the smallest particle
    Ks=dp*(((g*(rho_p-rho_a)*rho_a)/(meu^2))^(1/3));//Stokes Law applies as K<3.3
    vs=(g_acc*(dp^2)*rho_p)/(18*meu);
    ts=H/vs;
    Ls=ts*v_w*(5280/3600);//Converting miles/h to ft/s
    Vact=m*2000/rho_p;//Converting tons to lb
    Vb=Vact/e;
    Ld=Ls-L;
    A=Ld*W;
    Hdep=Vb/A;
end Ex23_7;
//============================================================================
