// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation
// Illustrative Example 24.5 Page Number 357
// Title - Angular speed required to spill the fluid
//========================================================================
model Ex24_5
//////Parameter section///////////////////////
//============================================
  parameter Real R(unit="ft")=0.25      "Radius of the cylinder";
  parameter Real g(unit="ft/s^2")=32.174"Acceleration due to gravity";
  parameter Real zst(unit="ft")=0.667     "Stationary height";
//============================================= 
///////Variable section///////////////////////////
  Real h_2(unit="ft")                 "Increase in Height h/2" ;
  Real omega(unit="rad/s")            "Angular speed";
//============================================== 
//Equation Section
equation
  h_2=1-zst;
  omega=((4*g*(h_2))/(R^2))^0.5;
end Ex24_5;
//============================================================================

