// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation
// Illustrative Example 24.7 Page Number 358
// Title - Thickness of the liquid film
//========================================================================
model Ex24_7
//////Parameter section///////////////////////
//============================================
  parameter Real Delz(unit="cm")=10      "Height difference of A and B";
  parameter Real rho(unit="kg/m^3")=1010 "Density of the fluid";
  parameter Real h(unit="m")=0.03        "Difference in the height of the liquid and the cylinder";
  parameter Real R(unit="m")=0.03        "Radius of the cylindrical cup";
  parameter Real g(unit="m/s^2")=9.807   "Acceleration due to gravity";
  parameter Real z_st(unit="m")=0.07     "Liquid height";
  parameter Real h_2(unit="m")=0.03      "Increase in height h/2";
//============================================= 
///////Variable section///////////////////////////
  Real OriginalH(unit="m")              "Original height";
  Real omega(unit="rad/s")              "Angular velocity which starts to spill the liquid";
  Real Pa(unit="Pag")                   "Pressure at A";
  Real Pb(unit="Pag")                   "Pressure at B";
  Real Pc(unit="Pag")                   "Pressure at C";
  Real zo(unit="m")                     "Liquid height above point C";
  Real r(unit="m")                      "Radius";
  Real thickness(unit="m")              "Thickness of the film";
//============================================== 
//Equation Section
equation
  (omega^2)=(2*g*h)/(R^2); 
  Pa=Pb;
  Pb=rho*g*Delz/100;//converting cm to m
  zo=z_st-h_2;
  Pc=rho*g*zo;
  OriginalH=z_st-zo;
  r=(((2*OriginalH*g)/(omega^2))^0.5);
  thickness=R-r;
end Ex24_7;
// Remark: The answer provided for omega is wrong.Calculation error.Hence the value of thickness differs.
//============================================================================
