// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 24 Sedimentation,Centrifugation and flotation
// Illustrative Example 24.9 Page Number 361
// Title - Size of the galena particle
//========================================================================
model Ex24_9
//////Parameter section///////////////////////
//============================================
  parameter Real meu_f(unit="kg/m.s")=0.001      "Viscosity of the fluid";
  parameter Real v(unit="m/s")=0.0073            "Terminal settling velocity";
  parameter Real g(unit="m/s^2")=9.807           "Acceleration due to grvaity";
  parameter Real rho_s(unit="kg/m^3")=7500       "Density of the particle";
  parameter Real rho_f(unit="kg/m^3")=1000       "Density of the fluid";
//============================================= 
///////Variable section///////////////////////////
  Real dp(unit="m")                              "Diameter of the particle";
  Real K                                         "Setlling factor";
//============================================== 
//Equation Section
equation
  dp=(((18*meu_f*v)/(g*(rho_s-rho_f)))^0.5);
  K=dp*(((g*(rho_s-rho_f)*rho_f)/(meu_f^2))^(1/3));//As K <3.3  Stokes law apply
end Ex24_9;
//============================================================================
