// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 25 Porous media and packed beds
// Illustrative Example 25.2 Page Number 371
// Title - Reynolds number
//========================================================================
model Ex25_2
//////Parameter section///////////////////////
//============================================
    parameter Real Dp(unit="mm")=5.50                "Diameter of the particle";
    parameter Real rho(unit="g/cm^3")=0.235          "Density of the fluid";
    parameter Real meu(unit="g/cm.s")=2E-4 "Viscosity of the fluid";
    parameter Real v(unit="cm/s")=10                  "Interstitial velocity";
//============================================= 
///////Variable section///////////////////////////    
    Real Re                                          "Reynolds number";
//============================================== 
//Equation Section    
equation
    Re=((Dp/10)*rho*v)/meu;// As Re > 2100.The flow is turbulent.
end Ex25_2;
//=========================================================================
