// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 25 Porous media and packed beds
// Illustrative Example 25.5 Page Number 373
// Title - Catalyst tower
//========================================================================
model Ex25_5
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi                 "The value of pi";
    parameter Real M=44.1                                        "Molecular weight";
    parameter Real P(unit="psf")=4320                            "Pressure";
    parameter Real R(unit="psi.ft^3/lbmol.degR")=10.73           "Gas constant";
    parameter Real T(unit="degR")=960                            "Temperature";
    parameter Real L(unit="ft")=50                               "Height of the tower";
    parameter Real D(unit="ft")=20                               "Diameter of the tower";
    parameter Real e=0.4                                         "Bed porosity";
    parameter Real theta(unit="s")=10                            "Contact time";
    parameter Real rho_s(unit="lb/ft^3")=77.28                   "Ultimate density";
    parameter Real dp(unit="ft")=0.0833                          "Diameter of the particle";
//============================================= 
///////Variable section///////////////////////////    
    Real ap(unit="ft^-1")                                        "Particle specific surface area";
    Real ab(unit="ft^-1")                                        "Bed specific surface area";
    Real rho_b(unit="lb/ft^3")                                   "Bulk density";
    Real rho(unit="lb/ft^3")                                     "Density of propane";
    Real V(unit="ft^3")                                          "Bed volume";
    Real q(unit="ft^3/s")                                        "Volumetric flow rate";
    Real vs(unit="ft/s")                                         "Superficial velocity";
    Real vi(unit="ft/s")                                         "Interstitial velocity";
//============================================== 
//Equation Section    
equation
    rho=(P*M)/(R*T*144);//Converting psi to psf
    V=(pi*(D^2)*L)/4;
    q=V*e/theta;
    vs=(4*q)/(pi*(D^2));
    vi=vs/e;
    rho_b=(1-e)*rho_s;
    ap=6/dp;
    ab=ap*(1-e);
end Ex25_5;
//Remark: Printing mistake in the value of  rho.
//=========================================================================
