//J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.USA, 2009.
// Edition : 1
// Chapter : 26 Fluidization
// Illustrative Example 26.5 Page Number 389
// Title - Pressure drop in a packed bed
//========================================================================
model Ex26_5
//////Parameter section///////////////////////
//============================================
    parameter Real v(unit="ft/s")=4.65           "Superficial velocity";
    parameter Real meu(unit="lb/ft.s")=1.3E-5    "Viscosity of air";
    parameter Real rho(unit="lb/ft^3")=0.067     "Density of air";
    parameter Real e=0.89                        "Void fraction";
    parameter Real gc(unit="lb.ft/lbf s^2")=32.2 "Conversion constant";
    parameter Real L(unit="ft")=10               "Length of the bed";
    parameter Real Dp(unit="ft")=0.007815        "Diameter of the particle";
//============================================= 
///////Variable section///////////////////////////
    Real DelP(unit="lbf/ft^2")"Pressure drop in a packed bed";
//============================================== 
//Equation Section    
equation
(DelP/L)=((150*v*meu*((1-e)^2))/(gc*(Dp^2)*(e^3)))+((1.75*rho*(v^2)*((1-e)^2))/(gc*Dp*(e^3)));
end Ex26_5;
//Remark: The answer provided for DelP is wrong as the value for rho has been wrongly taken as 0.67 instead of 0.067 lb/ft^3 and printing mistake in the Unit of DelP
//============================================================================
