// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 27 Filtration
// Illustrative Example 27.4 Page Number 414
// Title - Plate and frame filter press
//========================================================================
model Ex27_4
// The Plot of t/V vs V is shown in Fig 27.6 From which the data is obtained
//////Parameter section///////////////////////
//============================================
    parameter Real m(unit="s/L^2")=2.4285"Slope from the graph";
    parameter Real c(unit="s/L")=7.6715           "Intercept from the graph";
//============================================= 
///////Variable section///////////////////////////
     Real Kc(unit="s/ft^6")           "Coefficients Kc";
     Real qo(unit="s/ft^3")           "Coefficients 1/qo";
//============================================== 
//Equation Section 
equation
      Kc=2*m/(0.035315^2);//Converting L^2 to ft^6
      qo=c/0.035315;//Converting L to ft^3
end Ex27_4;
//============================================================================
