// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 27 Filtration
// Illustrative Example 27.9 Page Number 418
// Title - Filtration experiment
//========================================================================
model Ex27_9
//////Parameter section///////////////////////
//============================================
    parameter Real P(unit="psig")=50    "Operated Pressure";
    parameter Real q(unit="ft^3/min")=10"Intial Volumetric flow rate";
    parameter Real Vs(unit="ft^3")=100  "Volume collected in 1hr";
    parameter Real t(unit="min")=60     "Time required to collect 100 ft^3";
    parameter Real DelP(unit="psig")=50 "Pressure at 60 min";
    parameter Real Vw(unit="ft^3")=15   "Volume of wash water";
    parameter Real td(unit="min")=30    "Time for dumping and cleaning";
//============================================= 
///////Variable section///////////////////////////    
    Real C                       "Constant";
    Real B                       "Constant";
    Real tc(unit="min")          "Collecting time";
    Real qfilter(unit="gal/hr")  "Capacity of the filter";
    Real tw(unit="min")          "Time in washing";
//============================================== 
//Equation Section     
equation
    q=P/C;//When Vs=0
    t=((B*(Vs^2))/(2*DelP))+(C*Vs/DelP);//When t=60 min
    tw=(Vw*((B*Vs)+C))/DelP;
    tc=t+tw+td;
    qfilter=Vs/(tc/60);//Conversion from min to hr
end Ex27_9;
//============================================================================
