// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.3 Page Number 430
// Title - Minimum distance of the particle from emitting source
//========================================================================
model Ex28_3
//////Parameter section///////////////////////
//============================================
    parameter Real h(unit="ft")=150               "Cyclone height from ground level";
    parameter Real v_w(unit="miles/hr")=3 "Wind speed";
    parameter Real SG=1.96                        "Specific gravity";
    parameter Real rho(unit="lb/ft^3")=62.4       "Density of water";
    parameter Real P(unit="atm")=1                "Pressure";
    parameter Real M(unit="lb/lbmol")=29          "Molecular weight of air";
    parameter Real R(unit="atm.ft^3/lbmol.degR")=0.73"Gas Constant";
    parameter Real T(unit="degR")=520             "Temperature";
    parameter Real meu(unit="lb/ft.s")=1.22E-5    "Viscosity of the fluid";
    parameter Real g(unit="ft/s^2")=32.174         "Acceleration due to gravity";
    parameter Real d_p(unit="microns")=2.5        "Particle diameter";
//============================================= 
///////Variable section///////////////////////////    
    Real dp(unit="ft")                            "Particle Diameter";
    Real K                                        "Settling factor";
    Real rho_air(unit="lb/ft^3")                  "Density of air";
    Real v(unit="ft/s")                           "Terminal settling velocity";
    Real t(unit="s")                              "Time for descent";
    Real x(unit="miles")                          "Horizontal distance travelled in miles";
    Real rho_p(unit="lb/ft^3")                    "Density of the cement particle";
//============================================== 
//Equation Section    
equation
    dp=d_p/(25400*12);//Converting microns to ft
    rho_p=SG*rho;
    rho_air=P*M/(R*T);
    K=dp*((g*rho_p*rho_air/(meu^2))^(1/3));//As K < 3.3 Stokes law applies
    v=(g*(dp^2)*rho_p)/(18*meu);
    t=h/v;
    x=t*v_w/3600;// Printing mistake in the Expression(x=t/v_wind) in the book.
end Ex28_3;  
//=========================================================================
