// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.4 Page Number 432
// Title - To select the appropriate Filter system
//========================================================================
model Ex28_4
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi          "The value of pi";
    parameter Real q(unit="scfm")=10000                   "Volumetric flow rate of polluted air stream";
    parameter Real T(unit="degF")=60                      "Temperature";
    parameter Real To(unit="degF")=250                    "Operating Temperature";
    parameter Real vf(unit="ft/min")=2.5                  "Filteration velocity";
    parameter Real Da(unit="in")=8                        "Diameter of A";
    parameter Real Db(unit="in")=10                       "Diameter of B";
    parameter Real H(unit="ft")=16                        "Height";
    parameter Real cpba(unit="$")=26                      "Cost of per bag A";
    parameter Real cpbb(unit="$")=38                      "Cost per bag of B";
//============================================= 
///////Variable section///////////////////////////
    Real S_c(unit="ft^2")                                 "Filtering area";
    Real q_acfm(unit="acfm")                              "Gas flow rate";
    Real Na                                               "Number of bags A";
    Real Nb                                               "Number of bags B" ;
    Real S_a(unit="ft^2")                                 "Filtering Area of A";
    Real S_b(unit="ft^2")                                 "Filtering Area of B";
    Real TC_a(unit="$")                                   "Total cost for Bag A";
    Real TC_b(unit="$")                                   "Total cost for Bag B";
//============================================== 
//Equation Section
equation
//Bag D is eliminated  as the maximum Temperatue is below the operating Temperature 
//Bag C is eliminated as tensile strength should be above average.
    q_acfm=q*((To+460)/(T+460));//Conversion of degF to degR
    S_c=q_acfm/vf;
//For Bag A 
    S_a=pi*Da*H/12;//Conversion of in to ft
    Na=S_c/S_a;
//For Bag B
    S_b=pi*(Db/12)*H;//Conversion of in to ft
    Nb=S_c/S_b;
//Total Cost of each bag
    TC_a=Na*cpba;
    TC_b=Nb*cpbb;//As TC_a < TC_b Bag A is being choosen.
end Ex28_4;
//=========================================================================
