// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.5 Page Number 433
// Title - Number of filtering Bags
//========================================================================
model Ex28_5
//////Parameter section///////////////////////
//============================================
    final constant Real pi=Modelica.Constants.pi          "The value of pi";
    parameter Real q(unit="acfm")=50000                   "Volumetric flow rate";
    parameter Real v_f(unit="ft/min")=10                  "Velocity of filteration";
    parameter Real D(unit="ft")=1                         "Diameter of the filtering bag";
    parameter Real H(unit="ft")=15                        "Length of the filtering bag";
    parameter Real c(unit="lb/ft^3")=0.0007143            "Dust concentration";
    parameter Real DelP(unit="in.H2O")=8                  "Pressure drop";
//============================================= 
///////Variable section///////////////////////////    
    Real t(unit="min")                                    "Time with which the bag is cleaned";
    Real Sc(unit="ft^2")                                  "Filtering area";
    Real S(unit="ft^2")                                   "Area per bag";
    Real N                                                "Number of bags";
//============================================== 
//Equation Section    
equation
    Sc=q/v_f;
    S=pi*D*H;
    N=Sc/S;
    DelP=(0.2*v_f)+(5*c*(v_f^2)*t);
end Ex28_5;
//=========================================================================
