// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 28 Environmental management
// Illustrative Example 28.8 Page Number 436
// Title - Size of the aerobic digester
//========================================================================
model Ex28_8
//////Parameter section///////////////////////
//============================================
    parameter Real m(unit="lb")=1000        "Mass of solid that is generated";
    parameter Real OL(unit="lbVS/ft^3.day")=0.2 "Organic Loading";
    parameter Real th(unit="days")=20       "Detention time";
    parameter Real TS=0.044                 "Percentage of solids entering the digester";
    parameter Real VS=0.78                  "Volatile solids";
//============================================= 
///////Variable section///////////////////////////    
    Real Vol(unit="ft^3")                  "Volume of organic loading";
    Real Vhl(unit="ft^3")                  "Volume of hydraulic load";
//============================================== 
//Equation Section    
equation
    Vol=m*VS/OL;
    Vhl=(m*th)/(TS*8.33*7.48);//As Vhl > Vol .The design volume is Vhl and the hydraulic detention time controls.
end Ex28_8;
//Remark: The answers providied for Vhl in the textbook is wrong.Calculation Error.
//=========================================================================
