// J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
// Edition : 1
// Chapter : 3 Key Terms And Definitions 
// Illustrative Example 3.2 Page Number 25
// Title - Rise in height of the liquid in a capillary tube
//========================================================================
model Ex3_2
//////Parameter section///////////////////////
//============================================
    parameter Real sigma(unit="kg/s^2")= 0.0712        "Surface tension of water";
    parameter Real theta(unit="deg")=0                 "Contact Angle";
    parameter Real rho(unit="kg/m^3")=1000             "Density of the fluid";
    parameter Real D(unit="m")=0.008                   "Diameter of the capillary tube";
    parameter Real g(unit="m/s^2")=9.807               "Acceleration due to gravity";
//============================================= 
///////Variable section///////////////////////////
    Real h(unit="m")                                   "Height rise of liquid in a capillary tube";
//============================================== 
//Equation Section
equation
    h=(2*sigma*cos(theta))/(rho*g*(D/2));//As Radius R = D /2
end Ex3_2;
//============================================================================
