package Ex31_2
  // J.P.Abulencia and L.Theodore,Fluid Flow for the Practicing Chemical Engineer. John Wiley & Sons,Inc.,USA, 2009.
  // Edition : 1
  // Chapter : 31 Numerical methods
  // Illustrative Example 31.2 Page Number 492
  // Title - Calculating temperature using Newton Raphson Method
  //========================================================================

  model Ex31_2a
    //////Parameter section///////////////////////
    //============================================
    parameter Real t1(unit="K")= 1100              "Intial actual temperature";
    //=============================================
    ///////Variable section///////////////////////////
    Real t(unit="K")                               "Estimated Temperature";
    Real T[3](each unit="K")                       "Temperature";
    //==============================================
    //Equation Section
  equation
    T[1] = t1 / 1000;
    for i in 1:2 loop
      T[i + 1] = Ex31__2(T[i]);
    end for;
    t = T[3] * 1000;
  end Ex31_2a;

  //============================================================================

  function Ex31__2
    input Real T;//Inputing the value of T in K;
    output Real Temperature;//Outputing the value of T in K
  protected
    Real fv;//Function f(v)
    Real dfv;//Deravative of the Function
  algorithm
    fv := T ^ 3 - 2 * T ^ 2 + 2 * T - 1;
    dfv := 3 * T ^ 2 - 4 * T + 2;
    Temperature := T - fv / dfv;
  end Ex31__2;
  //===============================================================================
end Ex31_2;
